<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Message;

use Gls\GlsPoland\Carrier\CarrierType;

class CreateShopDeliveryCarrierCommand extends AbstractCreateCarrierCommand
{
    private $type;

    /**
     * @param string[] $countryIsoCodes
     */
    public function __construct(?string $name = null, array $countryIsoCodes = [])
    {
        $this->type = CarrierType::from(CarrierType::SHOP_DELIVERY);

        parent::__construct($name, ...$countryIsoCodes);
    }

    public function getType(): CarrierType
    {
        return $this->type;
    }

    public function isCashOnDelivery(): bool
    {
        return false;
    }
}
