<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook\Front\Checkout;

use Gls\GlsPoland\PrestaShop\Checkout\CheckoutResolverInterface;
use Gls\GlsPoland\PrestaShop\Checkout\Event\CarrierProcessEvent;
use Gls\GlsPoland\PrestaShop\Hook\HookInterface;
use Symfony\Component\HttpFoundation\Request;

final class ActionCarrierProcess implements HookInterface
{
    public const HOOK_NAME = 'actionCarrierProcess';

    private $checkoutResolver;

    public function __construct(CheckoutResolverInterface $checkoutResolver)
    {
        $this->checkoutResolver = $checkoutResolver;
    }

    /**
     * @param array{cart: \Cart, request: Request} $parameters
     */
    public function execute(array $parameters): void
    {
        $cart = $parameters['cart'] ?? null;
        $request = $parameters['request'] ?? null;

        if (!$cart instanceof \Cart || !$request instanceof Request) {
            return;
        }

        $this->checkoutResolver->dispatch(new CarrierProcessEvent($cart, $request));
    }
}
