<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Module;

use Gls\GlsPoland\PrestaShop\Asset\DTO\Assets;
use Gls\GlsPoland\PrestaShop\Checkout\CheckoutTrait;
use Gls\GlsPoland\PrestaShop\Checkout\ModuleCheckoutInterface;
use Gls\GlsPoland\PrestaShop\Checkout\Presenter\CheckoutConfigPresenter;
use Gls\GlsPoland\PrestaShop\ModuleRepository;
use Gls\GlsPoland\PrestaShop\Templating\RendererInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * The module does not offer any real ways to validate/process additional carrier data.
 */
final class WebkulOnePageCheckout implements ModuleCheckoutInterface
{
    use CheckoutTrait {
        CheckoutTrait::getAssets as getCommonAssets;
    }
    use ModuleControllerCheckerTrait {
        ModuleControllerCheckerTrait::supports as private isModuleController;
    }

    private const MODULE_NAME = 'wkonepagecheckout';

    public function __construct(RendererInterface $renderer, CheckoutConfigPresenter $dataPresenter)
    {
        $this->renderer = $renderer;
        $this->dataPresenter = $dataPresenter;
    }

    public static function getModuleName(): string
    {
        return self::MODULE_NAME;
    }

    public static function supports(\FrontControllerCore $controller, ModuleRepository $moduleRepository, ?Request $request = null): bool
    {
        if (self::isModuleController($controller, null, $request)) {
            return true;
        }

        if (!$controller instanceof \OrderControllerCore) {
            return false;
        }

        return $moduleRepository->isEnabled(self::MODULE_NAME);
    }

    public function getAssets(\Cart $cart): Assets
    {
        return $this
            ->getCommonAssets($cart)
            ->addJavaScript('js/front/wk-one-page-checkout.js'); // TODO: implement front-end 😨
    }

    private static function getCheckoutControllerNames(): array
    {
        return ['wkcheckout'];
    }
}
