<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Consignment\Builder;

use Gls\GlsPoland\AdePlus\Consignment\Consignment;
use Gls\GlsPoland\Consignment\DTO\AddressDetails;
use Gls\GlsPoland\Consignment\DTO\Parcel;
use Gls\GlsPoland\Consignment\DTO\ServiceDetails;

interface ConsignmentBuilderInterface
{
    /**
     * @return static
     */
    public function setReferences(?string $references): self;

    /**
     * @return static
     */
    public function setNotes(?string $notes): self;

    /**
     * @return static
     */
    public function setSenderDetails(?AddressDetails $senderDetails): self;

    /**
     * @return static
     */
    public function setRecipientDetails(?AddressDetails $recipientDetails): self;

    /**
     * @return static
     */
    public function setServiceDetails(?ServiceDetails $serviceDetails): self;

    /**
     * @return static
     */
    public function setParcels(Parcel ...$parcels): self;

    /**
     * @return static
     */
    public function setShippingDate(?\DateTimeImmutable $shippingDate): self;

    public function build(): Consignment;
}
