<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Orders;

use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;
use Gls\GlsPoland\AdePlus\Printout\PickupReceiptPrintMode;

interface ConfigurationInterface
{
    public function getLabelsPrintMode(): LabelsPrintMode;

    public function setLabelsPrintMode(LabelsPrintMode $printMode);

    public function getPickupReceiptPrintMode(): PickupReceiptPrintMode;

    public function setPickupReceiptPrintMode(PickupReceiptPrintMode $printMode);

    public function isDownloadLabelsAsSingleFile(): bool;

    public function setDownloadLabelsAsSingleFile(bool $downloadAsSingleFile);

    public function getLabelPrintedOrderStatusId(): ?int;

    public function setLabelPrintedOrderStatusId(?int $statusId);

    public function getConsignmentDeletedOrderStatusId(): ?int;

    public function setConsignmentDeletedOrderStatusId(?int $statusId);

    public function getDefaultReferences(): ?string;

    public function setDefaultReferences(?string $references);

    public function getDefaultNotes(): ?string;

    public function setDefaultNotes(?string $notes);

    public function getDefaultParcelWeightKg(): float;

    public function setDefaultParcelWeightKg(float $weight);
}
