<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\SenderAddress;

final class SenderAddress implements \JsonSerializable
{
    /**
     * @var string
     */
    private $name1;

    /**
     * @var string
     */
    private $name2;

    /**
     * @var string
     */
    private $name3;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $zipcode;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $street;

    public function __construct(
        string $countryIsoCode,
        string $zipCode,
        string $city,
        string $street,
        string $name1,
        string $name2 = '',
        string $name3 = ''
    ) {
        $this->country = $countryIsoCode;
        $this->zipcode = $zipCode;
        $this->city = $city;
        $this->street = $street;
        $this->name1 = $name1;
        $this->name2 = $name2;
        $this->name3 = $name3;
    }

    public function getName1(): string
    {
        return $this->name1;
    }

    public function withName1(string $name1): SenderAddress
    {
        $new = clone $this;
        $new->name1 = $name1;

        return $new;
    }

    public function getName2(): string
    {
        return $this->name2;
    }

    public function withName2(string $name2): SenderAddress
    {
        $new = clone $this;
        $new->name2 = $name2;

        return $new;
    }

    public function getName3(): string
    {
        return $this->name3;
    }

    public function withName3(string $name3): SenderAddress
    {
        $new = clone $this;
        $new->name3 = $name3;

        return $new;
    }

    public function getCountryIsoCode(): string
    {
        return $this->country;
    }

    public function withCountryIsoCode(string $isoCode): SenderAddress
    {
        $new = clone $this;
        $new->country = $isoCode;

        return $new;
    }

    public function getZipCode(): string
    {
        return $this->zipcode;
    }

    public function withZipCode(string $zipCode): SenderAddress
    {
        $new = clone $this;
        $new->zipcode = $zipCode;

        return $new;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function withCity(string $city): SenderAddress
    {
        $new = clone $this;
        $new->city = $city;

        return $new;
    }

    public function getStreet(): string
    {
        return $this->street;
    }

    public function withStreet(string $street): SenderAddress
    {
        $new = clone $this;
        $new->street = $street;

        return $new;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
