<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

use Gls\GlsPoland\AdePlus\Common\Services;
use Gls\GlsPoland\AdePlus\SenderAddress\SenderAddress;
use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class Consignment implements ResultInterface, \JsonSerializable
{
    /**
     * @var string|null
     */
    private $rname1;

    /**
     * @var string|null
     */
    private $rname2;

    /**
     * @var string|null
     */
    private $rname3;

    /**
     * @var string|null
     */
    private $rcountry;

    /**
     * @var string|null
     */
    private $rzipcode;

    /**
     * @var string|null
     */
    private $rcity;

    /**
     * @var string|null
     */
    private $rstreet;

    /**
     * @var string|null
     */
    private $rphone;

    /**
     * @var string|null
     */
    private $rcontact;

    /**
     * @var string|null
     */
    private $references;

    /**
     * @var string|null
     */
    private $notes;

    /**
     * @var int|null
     */
    private $quantity;

    /**
     * @var float|null
     */
    private $weight;

    /**
     * @var \DateTimeImmutable|null
     */
    private $date;

    /**
     * @var string|null
     */
    private $pfc;

    /**
     * @var SenderAddress|null
     */
    private $sendaddr;

    /**
     * @var string|null
     */
    private $srv_ade;

    /**
     * @var Services|null
     */
    private $srv_bool;

    /**
     * @var DAWOptions|null
     */
    private $srv_daw;

    /**
     * @var IDENTOptions|null
     */
    private $srv_ident;

    /**
     * @var PPEOptions|null
     */
    private $srv_ppe;

    /**
     * @var SDSOptions|null
     */
    private $srv_sds;

    /**
     * @var ParcelsCollection|null
     */
    private $parcels;

    public function getRecipientName1(): ?string
    {
        return $this->rname1;
    }

    public function withRecipientName1(?string $name): Consignment
    {
        $new = clone $this;
        $new->rname1 = $name;

        return $new;
    }

    public function getRecipientName2(): ?string
    {
        return $this->rname2;
    }

    public function withRecipientName2(?string $rname2): Consignment
    {
        $new = clone $this;
        $new->rname2 = $rname2;

        return $new;
    }

    public function getRecipientName3(): ?string
    {
        return $this->rname3;
    }

    public function withRecipientName3(?string $rname3): Consignment
    {
        $new = clone $this;
        $new->rname3 = $rname3;

        return $new;
    }

    public function getRecipientCountryIsoCode(): ?string
    {
        return $this->rcountry;
    }

    public function withRecipientCountryIsoCode(?string $isoCode): Consignment
    {
        $new = clone $this;
        $new->rcountry = $isoCode;

        return $new;
    }

    public function getRecipientZipCode(): ?string
    {
        return $this->rzipcode;
    }

    public function withRecipientZipCode(?string $zipCode): Consignment
    {
        $new = clone $this;
        $new->rzipcode = $zipCode;

        return $new;
    }

    public function getRecipientCity(): ?string
    {
        return $this->rcity;
    }

    public function withRecipientCity(?string $city): Consignment
    {
        $new = clone $this;
        $new->rcity = $city;

        return $new;
    }

    public function getRecipientStreet(): ?string
    {
        return $this->rstreet;
    }

    public function withRecipientStreet(?string $street): Consignment
    {
        $new = clone $this;
        $new->rstreet = $street;

        return $new;
    }

    public function getRecipientPhone(): ?string
    {
        return $this->rphone;
    }

    public function withRecipientPhone(?string $phone): Consignment
    {
        $new = clone $this;
        $new->rphone = $phone;

        return $new;
    }

    public function getRecipientContactInfo(): ?string
    {
        return $this->rcontact;
    }

    public function withRecipientContactInfo(?string $contactInfo): Consignment
    {
        $new = clone $this;
        $new->rcontact = $contactInfo;

        return $new;
    }

    public function getReferences(): ?string
    {
        return $this->references;
    }

    public function withReferences(?string $references): Consignment
    {
        $new = clone $this;
        $new->references = $references;

        return $new;
    }

    public function getNotes(): ?string
    {
        return $this->notes;
    }

    public function withNotes(?string $notes): Consignment
    {
        $new = clone $this;
        $new->notes = $notes;

        return $new;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function withQuantity(?int $quantity): Consignment
    {
        $new = clone $this;
        $new->quantity = $quantity;

        return $new;
    }

    public function getWeight(): ?float
    {
        return $this->weight;
    }

    public function withWeight(?float $weight): Consignment
    {
        $new = clone $this;
        $new->weight = $weight;

        return $new;
    }

    public function getShippingDate(): ?\DateTimeImmutable
    {
        return $this->date;
    }

    public function withShippingDate(?\DateTimeImmutable $date): Consignment
    {
        $new = clone $this;
        $new->date = $date;

        return $new;
    }

    public function getCostCenter(): ?string
    {
        return $this->pfc;
    }

    public function withCostCenter(?string $costCenter): Consignment
    {
        $new = clone $this;
        $new->pfc = $costCenter;

        return $new;
    }

    public function getSenderAddress(): ?SenderAddress
    {
        return $this->sendaddr;
    }

    public function withSenderAddress(?SenderAddress $senderAddress): Consignment
    {
        $new = clone $this;
        $new->sendaddr = $senderAddress;

        return $new;
    }

    public function getServicesAde(): ?string
    {
        return $this->srv_ade;
    }

    public function getServices(): ?Services
    {
        return $this->srv_bool;
    }

    public function withServices(?Services $services): Consignment
    {
        $new = clone $this;
        $new->srv_bool = $services;

        return $new;
    }

    public function getDeliveryAtWorkServiceOptions(): DAWOptions
    {
        return $this->srv_daw;
    }

    public function withDeliveryAtWorkServiceOptions(DAWOptions $options): Consignment
    {
        $new = clone $this;
        $new->srv_daw = $options;

        return $new;
    }

    public function getIdentificationServiceOptions(): IDENTOptions
    {
        return $this->srv_ident;
    }

    public function withIdentificationServiceOptions(IDENTOptions $options): Consignment
    {
        $new = clone $this;
        $new->srv_ident = $options;

        return $new;
    }

    public function getReturnServiceOptions(): ?PPEOptions
    {
        return $this->srv_ppe;
    }

    public function withReturnServiceOptions(?PPEOptions $options): Consignment
    {
        $new = clone $this;
        $new->srv_ppe = $options;

        return $new;
    }

    public function getShopDeliveryServiceOptions(): ?SDSOptions
    {
        return $this->srv_sds;
    }

    public function withShopDeliveryServiceOptions(?SDSOptions $options): Consignment
    {
        $new = clone $this;
        $new->srv_sds = $options;

        return $new;
    }

    public function getParcels(): ?ParcelsCollection
    {
        return $this->parcels;
    }

    public function withParcels(?ParcelsCollection $parcels): Consignment
    {
        $new = clone $this;
        $new->parcels = $parcels;

        return $new;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
